<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CClients extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		$this->name = "clients";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;



		if ($_GET["mod"] == $this->name) {

			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			switch ($sub) {
				case "landing":
					$_GET["sub"] = $sub = "items";
				case "items":
				case "cats":
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);
					return $data->DoEvents();
				break;


				case "texts":
					return $this->__adminTexts();
				break;

			}
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:clients_items" , 
			"plugin:clients_items_lang",
			"plugin:clients_cats" , 
			"plugin:clients_cats_lang",

		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {

		$this->CreatePageTitleBlock(array(
			"module_id"	=> $module_data["mod_id"],
			"title"		=> $module_data["mod_name"],
			"subtitle"	=> "You can edit this section in the Module Head tab",
			"show"		=> 1,
		));


		$this->plugins["modules"]->CreateLangRecord(
			$this->tables["plugin:clients_cats"],
			$this->tables["plugin:clients_cats_lang"],
			"cat_id",
			"cat_order",
			array(
				"module_id"		=> $module_data["mod_id"],
				"cat_title"		=> "Default Category",
				"cat_url"		=> "default-category",
				"cat_status"	=> "1",
				"cat_date"		=> time(),

				"cat_size"		=> 4,
				"cat_size_lg"	=> 4,
				"cat_size_md"	=> 4,
				"cat_size_sm"	=> 6,
				"cat_size_xs"	=> 12,
			)
		);



		//create layout

		$wid = $this->plugins["widgets"]->AddWidget(array(
			"type"			=> "cclientswidgetmenu",
			"type_name"		=> "Categories Menu",
			"title"			=> "Categories",
			"note"			=> "Auto-Generated",
			"settings"		=> array( "set_style"	=> "2"),
			"module"		=> $module_data["mod_id"],
		));

		$widgets = array("__CONTENT__");

		if (is_object($this->plugins["comments"])) {
			$widgets[] = $this->plugins["comments"]->GetCommentsWidget();
		}
		

		$layout = $this->plugins["layouts"]->SaveLayout(
			array(
				"name"			=> $module_data["mod_name"] . " - Details",
				"block"			=> array(
					"col"	=> array(

						0 => array("size"	=> 4 , "widget"	=> $wid),
						1 => array("size"	=> 8 , "widget"	=> $widgets),					
					)
				)				
			)
		);

		//update the layout id
		$this->plugins["modules"]->UpdateModuleSettings(
			$module_data["mod_id"] , 
			array(
				"set_layout_details"			=> $layout,
			)
		);



	}
	
	
}

?>